-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.ivTriggered = false
      self.svTriggered = false
    end
    
    self.ivHandler:LinkToTarget("ironVillage")
    self.ivHandler:LinkToTarget("questIron")
    self.ivHandler:LinkToTarget("offRaid")
    self.svHandler:LinkToTarget("stoneVillage")
    self.svHandler:LinkToTarget("questStone")
    self.svHandler:LinkToTarget("offRaid")
  end
  
  if not self.ivTriggered or not self.svTriggered then
    CheckForUnits(self)
  end
  
end

function CheckForUnits(self)
  p0units = self.p0:UnitsInRadiusNumber(self:GetPosition(), 2500, '*')
  
  if self:GetKey() == "villageIronHandler" and not self.ivTriggered then
    if p0units > 2 then
      self.ivHandler:TriggerAllTargets()
      self.ivTriggered = true
    end
  end
  
  if self:GetKey() == "villageStoneHandler" and not self.svTriggered then
    if p0units > 2 then
      self.svHandler:TriggerAllTargets()
      self.svTriggered = true
    end
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    OnAfterSceneLoaded(self)
    self.loaded = true
    self.ivTriggered = ar:Read()
    self.svTriggered = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.ivTriggered)
    ar:Write(self.svTriggered)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("ivHandler")
  self:AddTriggerSource("svHandler")
end
  